/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.Util;

public class TextConverter
implements Converter {
    private static final Logger logger = Logger.getLogger(TextConverter.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(TextConverter.class);
    private static final List<String> supportedExtensions = new ArrayList<String>();

    @Override
    public boolean accepts(String filename) {
        String extension = Util.getExtension(filename);
        return supportedExtensions.contains(extension);
    }

    @Override
    public boolean convert(String path, InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        String destString;
        boolean converted;
        String srcString = Util.toString(src, StandardCharsets.ISO_8859_1);
        boolean bl = converted = srcString != (destString = profile.convert(srcString));
        if (converted) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, sm.getString("textConverter.converted", path));
            }
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, sm.getString("classConverter.noConversion", path));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(destString.getBytes(StandardCharsets.ISO_8859_1));
        Util.copy(bais, dest);
        return converted;
    }

    static {
        supportedExtensions.add("java");
        supportedExtensions.add("jsp");
        supportedExtensions.add("jspx");
        supportedExtensions.add("tag");
        supportedExtensions.add("tagx");
        supportedExtensions.add("tld");
        supportedExtensions.add("txt");
        supportedExtensions.add("xml");
        supportedExtensions.add("json");
        supportedExtensions.add("properties");
        supportedExtensions.add("groovy");
    }
}

