/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.catalina.connector.Response;
import org.apache.tomcat.util.res.StringManager;

public class ResponseFacade
implements HttpServletResponse {
    protected static final StringManager sm = StringManager.getManager(ResponseFacade.class);
    protected Response response = null;

    public ResponseFacade(Response response) {
        this.response = response;
    }

    public void clear() {
        this.response = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void finish() {
        this.checkFacade();
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        this.checkFacade();
        return this.response.isSuspended();
    }

    public long getContentWritten() {
        this.checkFacade();
        return this.response.getContentWritten();
    }

    public String getCharacterEncoding() {
        this.checkFacade();
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.checkFacade();
        ServletOutputStream sos = this.response.getOutputStream();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return sos;
    }

    public PrintWriter getWriter() throws IOException {
        this.checkFacade();
        PrintWriter writer = this.response.getWriter();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return writer;
    }

    public void setContentLength(int len) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    public void setContentLengthLong(long length) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLengthLong(length);
    }

    public void setContentType(String type) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentType(type);
    }

    public void setBufferSize(int size) {
        this.checkCommitted("coyoteResponse.setBufferSize.ise");
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        this.checkFacade();
        return this.response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.checkFacade();
        if (this.isFinished()) {
            return;
        }
        this.response.setAppCommitted(true);
        this.response.flushBuffer();
    }

    public void resetBuffer() {
        this.checkCommitted("coyoteResponse.resetBuffer.ise");
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        this.checkFacade();
        return this.response.isAppCommitted();
    }

    public void reset() {
        this.checkCommitted("coyoteResponse.reset.ise");
        this.response.reset();
    }

    public void setLocale(Locale loc) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        this.checkFacade();
        return this.response.getLocale();
    }

    public void addCookie(Cookie cookie) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        this.checkFacade();
        return this.response.containsHeader(name);
    }

    public String encodeURL(String url) {
        this.checkFacade();
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        this.checkFacade();
        return this.response.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.checkCommitted("coyoteResponse.sendError.ise");
        this.response.setAppCommitted(true);
        this.response.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.checkCommitted("coyoteResponse.sendError.ise");
        this.response.setAppCommitted(true);
        this.response.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.checkCommitted("coyoteResponse.sendRedirect.ise");
        this.response.setAppCommitted(true);
        this.response.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        this.checkFacade();
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    public String getContentType() {
        this.checkFacade();
        return this.response.getContentType();
    }

    public void setCharacterEncoding(String encoding) {
        this.checkFacade();
        this.response.setCharacterEncoding(encoding);
    }

    public void setCharacterEncoding(Charset charset) {
        this.checkFacade();
        this.response.setCharacterEncoding(charset);
    }

    public int getStatus() {
        this.checkFacade();
        return this.response.getStatus();
    }

    public String getHeader(String name) {
        this.checkFacade();
        return this.response.getHeader(name);
    }

    public Collection<String> getHeaderNames() {
        this.checkFacade();
        return this.response.getHeaderNames();
    }

    public Collection<String> getHeaders(String name) {
        this.checkFacade();
        return this.response.getHeaders(name);
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.checkFacade();
        this.response.setTrailerFields(supplier);
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        this.checkFacade();
        return this.response.getTrailerFields();
    }

    private void checkFacade() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
    }

    private void checkCommitted(String messageKey) {
        this.checkFacade();
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString(messageKey));
        }
    }
}

