/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.ParameterAnnotationEntry;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public abstract class ParameterAnnotations
extends Attribute
implements Iterable<ParameterAnnotationEntry> {
    private ParameterAnnotationEntry[] parameterAnnotationTable;

    ParameterAnnotations(byte parameterAnnotationType, int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(parameterAnnotationType, name_index, length, (ParameterAnnotationEntry[])null, constant_pool);
        int num_parameters = input.readUnsignedByte();
        this.parameterAnnotationTable = new ParameterAnnotationEntry[num_parameters];
        for (int i = 0; i < num_parameters; ++i) {
            this.parameterAnnotationTable[i] = new ParameterAnnotationEntry(input, constant_pool);
        }
    }

    public ParameterAnnotations(byte parameterAnnotationType, int nameIndex, int length, ParameterAnnotationEntry[] parameterAnnotationTable, ConstantPool constantPool) {
        super(parameterAnnotationType, nameIndex, length, constantPool);
        this.parameterAnnotationTable = parameterAnnotationTable;
    }

    @Override
    public void accept(Visitor v) {
        v.visitParameterAnnotation(this);
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        return (Attribute)this.clone();
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        super.dump(dos);
        dos.writeByte(this.parameterAnnotationTable.length);
        for (ParameterAnnotationEntry element : this.parameterAnnotationTable) {
            element.dump(dos);
        }
    }

    public ParameterAnnotationEntry[] getParameterAnnotationEntries() {
        return this.parameterAnnotationTable;
    }

    public final ParameterAnnotationEntry[] getParameterAnnotationTable() {
        return this.parameterAnnotationTable;
    }

    @Override
    public Iterator<ParameterAnnotationEntry> iterator() {
        return Stream.of(this.parameterAnnotationTable).iterator();
    }

    public final void setParameterAnnotationTable(ParameterAnnotationEntry[] parameterAnnotationTable) {
        this.parameterAnnotationTable = parameterAnnotationTable;
    }
}

