/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.Utility;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class Unknown
extends Attribute {
    private static final Unknown[] EMPTY_ARRAY = new Unknown[0];
    private static final Map<String, Unknown> UNKNOWN_ATTRIBUTES = new HashMap<String, Unknown>();
    private byte[] bytes;
    private final String name;

    static Unknown[] getUnknownAttributes() {
        try {
            Unknown[] unknownArray = UNKNOWN_ATTRIBUTES.values().toArray(EMPTY_ARRAY);
            return unknownArray;
        }
        finally {
            UNKNOWN_ATTRIBUTES.clear();
        }
    }

    public Unknown(int name_index, int length, byte[] bytes, ConstantPool constant_pool) {
        super((byte)-1, name_index, length, constant_pool);
        this.bytes = bytes;
        this.name = constant_pool.getConstantUtf8(name_index).getBytes();
        UNKNOWN_ATTRIBUTES.put(this.name, this);
    }

    Unknown(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (byte[])null, constant_pool);
        if (length > 0) {
            this.bytes = new byte[length];
            input.readFully(this.bytes);
        }
    }

    public Unknown(Unknown c) {
        this(c.getNameIndex(), c.getLength(), c.getBytes(), c.getConstantPool());
    }

    @Override
    public void accept(Visitor v) {
        v.visitUnknown(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        Unknown c = (Unknown)this.clone();
        if (this.bytes != null) {
            c.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, c.bytes, 0, this.bytes.length);
        }
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (super.getLength() > 0) {
            file.write(this.bytes, 0, super.getLength());
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public String toString() {
        String hex;
        if (super.getLength() == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (super.getLength() > 10) {
            byte[] tmp = new byte[10];
            System.arraycopy(this.bytes, 0, tmp, 0, 10);
            hex = Utility.toHexString(tmp) + "... (truncated)";
        } else {
            hex = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + hex + ")";
    }
}

