﻿# Duplicate Files Search & Link (aka Duplicate & Same Files Searcher) version history

## Version 10.7.0 from 2025 September 18
 - Minor update.
 - Updated Hungarian translation.

## Version 10.7.0 from 2025 August 24
 - Implemented support for file comparison and search for duplicate files in folders, which can now be dragged and dropped with the mouse from the explorer. The search and comparison is performed with the settings of the Default profile.

## Version 10.6.6 from 2025 July 26
 - Updated component versions.

## Version 10.6.5 from 2025 July 06
 - Fixed an error that sometimes occurred under certain conditions when updating the file list after operations.
 - Added Turkish translation.
 - Updated component versions.

## Version 10.6.4 from 2025 June 24
 - Fixed bug: file scanning may freeze when comparing .cr2 files (Canon Digital Camera Raw Image) if the option "Ignore metadata and tags differences for audio, video and image files" is enabled.
 - Fixed an issue with identifying SSD drives - external drives of the WD My Passport model were identified as SSD drives because they support TRIM.
 - Fixed SSD detection issue: "WD Passport" detected as SSD because it supports TRIM.
 - Updated Chinese language translation.

## Version 10.6.3 from 2025 May 10
 - Fixed a couple of minor issues.

## Version 10.6.2 from 2025 March 30
 - Fixed an issue: hard and symbolic links creation was not enabled when using network UNC paths (without mapped network drive).
 - Fixed an UI issue in the "Select folders to search..." dialog by entering network UNC paths in the text edit box.

## Version 10.6.1 from 2025 January 20
 - Fixed an issue with automatic updating of the file list when deleting files by external programs, such as file managers.
 - The program now always enables support for hard links and symlinks on NTFS-formatted network drives, even if the file server does not report supporting these features.
 - Fixed: The build for the .NET 6.0 platform did not recognize SSD drives.

## Version 10.6.0 from 2024 December 27
 - Added .NET 9.0 support.
 - Added several new commands for selecting and deselecting files.
 - Fixed the behavior of the search window by pressing Ctrl+F if the window is already opened.
 - Slightly improved startup speed.
 
## Version 10.5.1 from 2024 October 13
 - Fixed an issue that caused the error "NLog.dll file not found" when running the DuplicateSearcherNetFramework.exe on some systems.
 - Updated components.
 - Removed .NET 7.0 support because it has reached the end of life.

## Version 10.5.0 from 2024 May 15
 - Added support for the Compact OS utility built into Windows 10 and 11 to compress files on the fly on NTFS, you can use it instead of the standard NTFS compression. It compresses files with higher compression ratio (but the files compressed in Windows 10 cannot be opened in Windows 7, 8.1 or Linux etc).
 - Added support for deleting files from .ZIP archives.
 - Implemented multithreaded file replacement with hard links and multithreaded file deletion on SSD drives.
 - Added a new command "Unselect Files With the Most Hard Links".
 - The "Partial comparison of large video files" option supports video files of 25 MB or more by default.
 - Fixed several bugs.

## Version 10.4.2 from 2024 March 23
 - Fixed a small issue in UI.

## Version 10.4.1 from 2024 March 22
 - Fixed a problem with scrolling to the top of the grid after operations on files.
 - Fixed a problem: information about symbolic links was not restored by loading a file with saved search results.
 - Fixed a problem with slow loading of a file with saved search results containing a large number of files.

## Version 10.4.0 from 2024 February 23
 - Added a new command "Select Files with the Most Hard Links as Link Targets".
 - Added the option "Automatically rename file if a file with the same name already exists in the destination folder" in the file renaming dialog.
 - Added automatic updating of the folder tree when an (external) disk attached to or removed from the system.
 - Fixed the function of the button "Show/Hide physical devices."
 - Fixed an error by automatic updating of the installed version.
 - Fixed minor bugs.

## Version 10.3.3 from 2024 January 23
 - Fixed: The occupied disk space was incorrectly displayed for files larger than 4 GB.

## Version 10.3.2 from 2024 January 16
 - Fixed the issue: the result grid scrolled to the beginning after any file operation.
 - Fixed the filter selection dialog behavior: the selection by paths from the list did not work correctly if a path ends in slashes.
 - Improved behavior after a file deletion request when all files are selected in one or more groups.

## Version 10.3.1 from 2023 December 25
 - Fixed a bug: after replacing files with hard links, groups with hard- and sym- links in the grid were not shown automatically without repeated replacing or rescan.
 - Fixed: the size of the main window was not restored if the window's edge was at the edge of the screen.
 - Added translation into Portuguese [Brazil].

## Version 10.3.0 from 2023 December 03
 - Improved performance, fixed several minor bugs.
 - Added .NET 8.0 support.

## Version 10.2.3 from 2023 May 06
 - Fixed bug: Duplicate Searcher Launcher can't launch the standalone (portable) version 10.2.2. 

## Version 10.2.2 from 2023 April 30
 - Fixed several minor issues found in UI.
 - Fixed a problem with running .NET 7.0 version under Windows 7 in administrator mode (the environment variables set to bypass the memory allocation problem for the .NET 7.0 process were not passed by running in administrator mode).

## Version 10.2.1 from 2023 April 02
 - Fixed a bug: some of duplicate files are sometimes ignored.
 - Fixed an issue: some symbolic links are being incorrectly shown.
 - The command "Select All Files in '[selected folder]' and Sub-folders" is used in the context menu instead of "Select All Files in '[selected folder]'".

## Version 10.2.0 from 2023 March 28
 - Improved performance on older CPUs, reduced CPU load when comparing files.
 - Fixed a performance issue when comparing several thousand files of the same size, the comparison speed has increased by several times.
 - Fixed some found issues in the UI.
 - Fixed and improved keyboard navigation through the grid of identical files, also added support for keyboard shortcuts Ctrl-Up/Ctrl-Down for jumping between groups of files.
 - Selected folders are now saved separately for each search profile.

## Version 10.1.4 from 2023 February 27
 - Fixed issue: the message "New version 10.1.3 available for download" is shown even if 10.1.3 is already installed.

## Version 10.1.3 from 2023 February 24
 - Fixed issue: command button "Replace Files With Hard Links" is available for files on file system FAT32.
 - Updated Hungarian translation.

## Version 10.1.2 from 2023 January 12
 - Improved performance.
 - Improved sorting by size.
 - Replaced the code signing certificate with the new one (the previous was the test one and it is not valid anymore).

## Version 10.1.1 from 2023 January 03
 - The installer, all *.exe and *.dll files are now signed with a trusted code signing certificate. Therefore there is no "unknown publisher" warning anymore by running Duplicate Searcher.
 - The file access rights compatibility check during replacing files with hard links is now available without running as administrator.

## Version 10.1.0 from 2023 January 01
 - Added new column Extension with filtering and sorting support.
 - Fixed minor bugs.

## Version 10.0.5 from 2022 December 19
 - Fixed: the main menu items did not fit into the window and being hidden when the window width was decreased or when the medium and large fonts were selected in the settings.
 - Fixed: some visual issues of the filter panel.

## Version 10.0.4 from 2022 December 12
 - A work-around has been implemented in the launcher to fix the problem with .NET 7.0 high memory allocations on 64-bit Windows 7.
	It sets environment variables to values that disable new technologies that cause problems on 64-bit Windows 7. Duplicate Searcher should now work without problems if it runs on 64-bit Windows 7 with .NET 7.0 installed.
	Unfortunately, Microsoft refused to support and fix .NET 7.0 bugs on Windows 7, so make your decision to use .NET 7.0 with 64-bit Windows 7, given the missing support, missing bugfixes, and the given problem I described.
 - Added additional checks in the launcher if needed components are installed on Windows 7 and Windows 8/8.1.

## Version 10.0.3 from 2022 December 09
 - The problem with high .NET 7.0 memory allocation on Windows 7 does not affect Windows 7 32-bit and 32-bit mode on Windows 7 64-bit, so running the 32-bit DuplicateSearcherNet7.x86.exe assembly for .NET 7.0 is enabled without restrictions in this version on 32-bit and 64-bit Windows 7.
 - Fixed slight slowdown when comparing media files with "Ignore difference in metadata..." option enabled.

## Version 10.0.2 from 2022 December 08
 - Windows 7 64-bit users: Build DuplicateSearcherNet7.x64.exe for .NET 7.0 allocates a lot of memory at startup on Windows 7 64-bit due to .NET 7.0 incompatibilities.
	Until the problem is found and fixed, the launch of DuplicateSearcherNet7.x64.exe for .NET 7.0 is disabled in the DuplicateSearcher.Launcher.exe on Windows 7.
	The build for .NET 6.0 or .NET Framework 4.7.2 will be run instead.
	Windows 7 users please use executable files for .NET 6.0 (in the net6.0 folder) or for .NET Framework 4.7.2 (in the netfx folder). They work fast too.
 - Fixed a bug in the DuplicateSearcher.Launcher.exe, which could not find the file DuplicateSearcherNetFramework.exe by users who do not have .NET 6.0 or .NET 7.0 installed.

## Version 10.0 from 2022 December 07
 - Added build for new .NET 7.0 platform.
 - Slightly improved performance.
 - Fixed minor bugs.
 - Added automatic profiles for audio, video and image files.
 - Added simple media tags preview window.
 - New commands that allow you to select immediately target files for hard links without first selection of files that should be replaced with hard links.
 - Returned possibility to select files as hard link target for mapped network drives, formatted to Linux EXT2,3,4. In version 9.0 it was not possible for some NAS-drives because they don't report correctly to Windows if hard links are supported by them.
 - Simple scripting support.
 - Changed files and directory structure to separate binary exe and dll files for platforms .NET Framework 4.7.2, .NET 6.0 and .NET 7.0.

====

## Version 9.0.5 from 2022 October 28
 - Fixed an error caused the unhandled exception if the file IncompressibleFiles.txt is missing in the application folder.

## Version 9.0.4 from 2022 October 26
 - Fixed several errors causing unhandled exceptions.
 - Fixed problem in DuplicateSearcherNetFramework.exe for .Net Framework: keyfiles were not loaded, some menu items were missing.

## Version 9.0.3 from 2022 September 18
 - Fixed issue: the application shows an error and don't work, if .NET Framework 2.0/3.5 was not installed yet on a fresh system. This dependency on .NET Framework 2.0/3.5 is removed.

## Version 9.0.2 from 2022 September 11
 - Fixed several minor UI-issues.
 - Implemented multiple file selection by left click + Shift.

## Version 9.0.1 from 2022 September 07
 - Updated Polish and Chinese language files.
 - Fixed issues with auto-update of language files.

## Version 9.0.0 from 2022 September 05
 - Added the possibility of additional grouping of files by disk, folder and file name.
 - Automatic selection of a new file for hard links was implemented when replacing more than 1023 files with hard links (NTFS file system has the limit of 1024 hard links per file).
 - Added support for replacing symbolic links with hard links.
 - Added the ability to continue the search with new settings and append the newly found duplicates to the existing files.
 - Increased the file comparing speed in different scenarios.
 - When launching the .NET 6.0 version, the program now will also automatically receive an additional speed boost on modern processors with AVX and SHA256 hardware acceleration support.
 - Also solved performance problems in some search scenarios with a large amount of found files.
 - Added the ability to mark disks/volumes as SSD manually, it speeds up the search on mounted virtual hard disks, VeraCrypt volumes etc. physically located on SSD.
 - Added support of hard and symbolic links on the ReFS file system (but not tested yet).
 - Added preventing of automatic going into sleep or hibernation due to user inactivity by long running duplicate search.

====

## Version 8.0.10 from 2022 August 05
 - Fixed crash by comparing certain combination of many small files.

## Version 8.0.9 from 2022 Mai 08
 - Fixed some minor bugs.
 - Added Hungarian translation.
 - Added support slash '/' as folder separator in paths for scanning passed via the command line, i.e. Unix style (for example "e:/Photo/Photo " instead of "e:\Photo\Photo").
 - Added new DuplicateSearcher.Launcher.exe to run automatically the best suitable version depends on installed .NET runtime (6.0, 5.0 or 4.8) and system architecture (32 or 64 bit). 
I recommend installing the latest .NET 6.0 for the best performance and stability (https://dotnet.microsoft.com/en-us/download/dotnet/6.0/runtime).

## Version 8.0.8 from 2021 December 05
 - Less CPU load and better performance when multiprocessing duplicate search on SSD on some configurations.
 - Fixed found minor bug caused error message on some systems.

## Version 8.0.7 from 2021 December 01
 - Fixed a minor bug.
 - Added new portable package for new .NET 6 platform (please download it separately on my web site).

## Version 8.0.6 from 2021 October 27
 - Fixed broken translations some menu items with ellipsis at the end.

## Version 8.0.5 from 2021 October 27
 - Fixed the error System.BadImageFormatException by starting the application on some systems.

## Version 8.0.4 from 2021 October 24
 - Significantly improved performance when comparing thousand of small files of the same size.
 - Fixed problem with incorrect window scaling in .NET 5 version (DuplicateSearcherCore.exe) when selecting text scale of 150% or higher on Windows 10.
 - Fixed problem with long-term "freezing" of the user interface after moving a very large amount of files to another disk.
 - Added a 32-bit version of DuplicateSearcherCore.exe for the .NET 5 platform (DuplicateSearcherCore.x86.exe), to run on 32-bit Windows 7, Windows 8.1, Windows 10 versions.

## Version 8.0.3 from 2021 May 23
 - Fixed a bug - identical video files larger than 2 GB were not found when the "Partial comparison of large video files" option was enabled.
 - Minor improvements and bug fixes.

## Version 8.0.2 from 2021 April 17
 - Fixed the issue with the interface "freezing" for a long time by starting the operation of deleting a large amount of files.
 - Fixed incorrect search in DuplicateSearcherCore.exe (for .NET 5) due to the incorrect implementation of some functions in .NET 5.
 - Implemented uniform file sorting order in versions DuplicateSearcher.exe (for .NET 4.7.2+) and DuplicateSearcherCore.exe (for .NET 5).

## Version 8.0.1 from 2021 April 11
 - Added new option "Partial comparison of large video files". When enabled, large video files (from 250 MB) are compared partially in different parts (~4 MB every 100 MB). This option allows you to estimate quickly if the video files are the most likely identical.
 - Added an estimation of the time remaining to complete long running operations (scanning and others).
 - Added the new column "Files", which allows you to sort file groups by the number of files in them.
 - Added the context menu opening by the right click on the table header row, which allows you to hide unnecessary columns.
 - The dialog box of the "Filtered selection" command has been redesigned, the selection has been simplified, and the "Invert Selection" operation has been added.
 - Fixed several bugs found in the previous version.
 - Reduced memory usage during searching duplicates.
 - Improved scanning performance by several percent.
 - The new application DuplicateSearcherCore.exe built for .NET 5.0 platform is back. Please update first .NET Desktop Runtime to version 5.0.4 or higher to run it.
 - If you like the application, please do consider to thank to support my motivation to develop it further! 

====

## Version 7.0.7 from 2021 January 14
 - Fixed found issues.
 - Fixed bug: saved scan results couldn't be loaded in some circumstances.
 - The new application DuplicateSearcherCore.exe for .NET 5.0, which has been added since version 7.0.6, is temporarily excluded due to GDI resource leak found in some graphic functions provided by .NET 5.0. 

## Version 7.0.6 from 2020 December 19
 - Fixed minor bugs.
 - People who use portable version can try the new application DuplicateSearcherCore.exe, adapted and compiled to use the newest platform .NET Desktop Runtime 5.0.
.NET 5.0 includes performance improvements, therefore the application DuplicateSearcherCore.exe should run faster than standard DuplicateSearcher.exe for .NET Framework 4.7.2.
Please download and install .NET Desktop Runtime 5.0 https://dotnet.microsoft.com/download/dotnet-core/5.0/runtime/ to run DuplicateSearcherCore.exe.
The installer will also copy the executable file DuplicateSearcherCore.exe for .NET 5.0 to the application's folder in Program Files, but the shortcut for it won't be created and the executable file will not be launched automatically.
You can create a shortcut and run it yourself, if you like.
I'll add a launcher in the future versions to select and run automatically the .NET 5+ version, if the required .NET Desktop Runtime is already installed on the machine.
The new .NET 5+ will be primary platform for future application development.

## Version 7.0.5 from 2020 October 23
 - Bugfixing: missing directory icons and slow performance after repeated search.

## Version 7.0.4 from 2020 September 21
 - Fixed GDI+ exceptions caused application to crash after large amount of files were scanned. The GDI+ errors caused by Windows limitations on the number of file icons which can be created in memory simultaneously.
 - Fixed OutOfMemoryException if error output panel contains too much errors. Maximum error count limited to 1000.
 - Added output error info about symbolic links pointing to non-existing files (broken links).
 - Added Spain (Colombia) language translation (thanks to Carlos Andrés Medina Rivera!).

## Version 7.0.3 from 2020 September 08
 - Improved file symlinks detection. Previous versions skipped symlinks to single files without duplicates.

## Version 7.0.2 from 2020 September 07
 - Fixed: the logging for completed file operations was broken.

## Version 7.0.1 from 2020 September 06
 - I made visible the list of selected paths for search duplicates under the folder tree in the Start Search dialog for better overview. Also added separated "Select All" and "Unselect All" tool buttons for the folder tree. 

## Version 7.0 from 2020 July 27
 - Added support searching for audio, video and image (only .jpg) files with the same binary media content but different metadata and media tags.
 - Added support launching customer external cmd-files and tools (for example Beyond Compare) for selected files.
 - Added the new command "Copy Selected Lines To Clipboard in .csv-format".

====

## Version 6.0.3 from 2020 June 09 
 - Improved scanning performance in some scenarios.
 - Fixed issue: file modification time is now displayed as local time in UI. In all older version file modification time was displayed in UTC.
 - Fixed broken auto-update for portable version.

## Version 6.0.2 from 2020 June 06 
 - Fixed bug: false positives by comparing .mp3 files if option "Ignore ID3-tag differences for MP3 files" is enabled.

## Version 6.0.1 from 2020 June 05 
 - Fixed bug disallowed to create symlinks to files located on another disks (volumes).

## Version 6.0.0 from 2020 June 03 
 - Several times better performance by simultaneous search for duplicates on several independent physical drives.
 - Several times better performance by search for duplicates on SSDs (e.g. 3-4 times on SATA-SSD by scanning using 4 threads). 
SSDs are being recognized automatically.
 - Drive letters (volumes) are grouped in folder tree by physical drives which they belong to.
 - Added support for hard links and symbolic links in EXT2/EXT3/EXT4 file systems (I've tested it only with Ext2Fsd-driver for Windows https://www.ext2fsd.com/ ).
 - Implemented search for duplicates in ZIP-archives. In order to search in ZIP-archive it should be added under "Archive" node in the folder tree. File operations with files in ZIP-archive (rename, delete etc) are not supported.
 - Added possibility to assign custom keyboard shortcuts.
 - Added possibility to move files including folder structure.
 - Several small fixes and improvements.
 - Windows XP: this version was build for .NET Framework 4.7.2 and above, which has more features and better performance, but it doesn't support Windows XP.

====

## Version 5.2.7 from 2020 April 25
 - Fixed bug caused NullReferenceException in the "Move files" dialog.
 - Fixed bug caused the creation of excess Settings subfolder during the update of the installed version via automatic update function.

## Version 5.2.6 from 2020 March 23
 - Added skipping files in the OneDrive folder that physically aren't on the local computer (files in the cloud).
Files in the cloud are now excluded from search by default, but if you like to include cloud files to search for duplicates and let OneDrive download them to your computer for comparison, you can set SkipFilesInCloud="0" in the Profile settings in the file settings.xml. 
It's just a quick fix. The checkbox in the UI for the setting will be added in a future version.

## Version 5.2.5 from 2020 February 28
 - Fixed a small issue.

## Version 5.2.4 from 2020 February 16
 - Fixed crashes on some system configurations caused by non-existing fonts.
 - Fixed found UI problems caused by the selected medium or large font size.
 - Fixed found some rare crashes on some user configurations.
 - Added key without expiration date for non-commercial use.

## Version 5.2.3 from 2019 December 06
 - Fixed some small issues. 
 - Improved stability.

## Version 5.2.2 from 2019 October 17
 - Fixed Windows 10 specific issue - 0 "Size on the disk" for some system files in the WindowsApps folder.

## Version 5.2.1 from 2019 October 8
 - Fixed several found issues, caused crashes.

## Version 5.2 from 2019 September 1
 - Added new button "Show only groups containing selected files" on the side toolbar.
 - Added displaying of current disk read speed during file comparison.
 - Fixed a couple of unhandled exceptions that could cause crashes.
 - Minor performance improvement.

## Version 5.1.9.1 from 2019 August 14 
 - Updated Polish translation.

## Version 5.1.9 from 2019 August 13
 - Fixed crash by scanning files in network folders.
 - Fixed crash by scanning mp3-files with unusual ID3v2 tags when the option "Ignore ID3-tag differences for MP3 files" is enabled. 
 - Fixed (or better to say got around) the reported error by opening system Save File Dialog on some systems (the most probably some system components are missing there). 
 - Columns width and order are now saved and restored then program restarts.
 - Added possibility to select and deselect files starting from parent folders of the highlighted file.
 - Added Chinese (Simplified) translation.

## Version 5.1.7 from 2019 August 09
 - Fixed another critical bug: the app freezes when user clicks click the "Start search" button if the previous search was in network folders.

## Version 5.1.6 from 2019 August 08
 - Fixed several bugs leading to crashes of the application.
Thanks to the people who sent me the reports!
 - Fixed functionality "Ignore ID3-tag differences for MP3 files". It finds much more MP3 files now with differences in ID3 tags only.

## Version 5.1.5 from 2019 July 23
 - Found and fixed two problems that sometimes led to occasional program crashes in some circumstances. 
One problem is a bug in the .Net Framework.
Thanks to the people who sent me the reports!
 - This version should still run under Windows XP. ;-)

## Version 5.1.4 from 2019 July 15
 - Fixed bug: "Move files" operation didn't work.
 - Search settings are now saved automatically even if the Search dialog was closed by Cancel button or Esc.  
 - Dll-files repacked into one .exe-file to decrease files count for portable version.

## Version 5.1.3 from 2019 June 10
 - Decreased CPU load by scanning large amount of files.
 - Fixed unhandled exception if added network path isn't available anymore.
 - Fixed bug with limiting symlinks count for registered users.

## Version 5.1.2 from 2019 April 21
 - Fixed broken search in network folders.

## Version 5.1.1 from 2019 April 08
 - Fixed: freed up space summary was incorrectly cleared by some UI operations.
 - Updated French translation. Thanks to Colok!
 - Attention Windows XP users: this version is likely to be the latest, compiled for .NET 4.0, and therefore supports Windows XP.
  I plan to build new versions with support for new technologies and features of .NET 4.6.2+ (and .NET Core 3.0) which are not supported in WinXP.
  But in case of finding critical errors in this version, the bug fixes of this version for .NET 4.0 will be made.

## Version 5.1.0 from 2019 April 02
 - Fixed a bug with the inability to filter files from the list by name, which appeared in the previous version.
 - Fixed several minor bugs.
 - Added the ability to sort within groups by file names, folders, number of fragments, hard links and file modification date.
 - Added display of extended statistics on found duplicates, free disk space and the number of deleted and replaced files in the status bar.
 - Added the ability to specify the path to search for files as a text list of paths.
 - Added ability to copy to the clipboard the path of the file folders.
 - Increased speed rendering of the list of duplicate files.
 - Several commands were renamed.

## Version 5.0.3 from 2019 February 15
 - Hotfix: fixed crash by search file names via "Find in List…".
 - Added: German language.

## Version 5.0.1 from 2018 December 01
 - Updated a tooltip.

## Version 5.0 from 2018 November 18
 - Added support for file symbolic links (search, display and creation).
 - Fixed several found issues and bugs.
 - Several performance improvements. In some complicated cases (e.g. by comparing many files of the same size) the search can be several times faster!

====

## Version 4.3 from 2016 April 29
 - Fixed bug - search didn't work on 32-bit Windows versions.

## Version 4.2 from 2016 April 20
 - Added support for patterns in file name and file path filters of result grid. You can use the list of patterns separated by '|' (or ';'), for example: 'DSC*.JPG | IMG*.JPG' etc.
 - Added the new option to skip NTFS-compression for incompressible and poorly compressible files when you use 'Compress' command. It reduces file fragmentation on HDDs and wearing on SSDs. 

## Version 4.1.1 from 2016 February 15
 - Fixed bug: option "Automatically Check For Updates" does not work in versions 4.0 and 4.1.
 - The NTFS-compression operation ignores small files (up to 4 KB).
 - Fixed rare crash

## Version 4.1.0 from 2016 February 05
 - Significantly improved hard links comparing performance.
 - Implemented Windows Explorer context menu integration (only by installation, not supported in portable version). The search of duplicate files can be started from Windows Explorer context menu on selected folders or discs.
 - Added support of the new optional command-line parameters:
	-s "Path1;[Path2;][Path3;]": search file duplicates in paths separated by ';'.
		Example: DuplicateSearcer.exe -s "D:\Photos1;D:\Photos2;"
	-profile "<ProfileName>": select profile name to be used for search started from command line. 
		If the parameter is missing or given profile name doesn't exist, settings from default profile "Default" will be used.
		Example: DuplicateSearcer.exe -s "D:\Photos1;D:\Photos2;" -profile "Photos".

## Version 4.0.0 from 2015 December 15
 - Developed to target the Microsoft .NET Framework 4. It means better performance and no need to install .Net 3.5 on Win 10 and Win 8.1.
 - Added support of user-defined profiles to search files by different criteria.
 - Added filters row in the result list to filter files by different criteria.
 - Fixed several found small issues.
 - Portable version saves settings in the application's subfolder now.
 - "Start As Administrator" is disabled by default.

## Version 3.0.1 from 2015 March 01
 - Fixed several minor UI bugs.

## Version 3.0.0 from 2015 January 12
 - Fixed several small bugs.
 - Added preview of image files in hits on mouse hover.
 - Added displaying of extended properties of media files in hits on mouse hover.
 - Added some new commands to select files.

====

## Version 2.2.6 from 2014 May 20
 - Added new search option "Search only for duplicates with the same file names".
 - Fixed bug: the operation "Move Files To Specified Folder" didn't work properly.

## Version 2.2.3 from 2014 January 31
 - Added possibility to increase the font size.
 - Minor improvement.

## Version 2.2.1 from 2013 October 19
 - Fixed bug: Include/Exclude wildcards did not always work correctly by the file search.

## Version 2.2.0 from 2013 October 01
 - Added logging for successfully completed file operations.
 - Added option to delete empty folders after file deletion.
 - Added French translation.

## Version 2.1.3 from 2013 July 27
 - Fixed bug: error message by expanding disc C: in the "Select folders to scan" window.
I'm very sorry if you encountered it!

## Version 2.1.2 from 2013 July 16
 - Fixed bug: file list was not updated after files were deleted to Recycle Bin.
 - Added: Duplicate Searcher prevents delete operation if all files were checked for deletion.

## Version 2.1.1 from 2013 June 26
 - Minor update.

## Version 2.1.0 from 2013 March 06
 - Implemented feature: you can add network folders and use them to scan for duplicates.
 - Implemented the new version-history and update dialog.
 - Fixed casual crash by clicking on "Send Feedback or Bug Report" menu item if The Bat! app is installed.

## Version 2.0.3 from 2013 January 28
 - Resolved problem: dialog "Incompatible file permissions" was being opened and updated very slowly in some cases.
 - Status window is now shown by loading result files when file information is being updated.
 - The sizes of the found and checked files in status bar display the real disc space used by files (not just the sums of file sizes as it was before). 

## Version 2.0.2 from 2013 January 11
 - Added: Polish language.

## Version 2.0.2 from 2012 December 02
 - Improved files loading/updating speed when loading scanning results from the file.
 - Added support for loading result files via command line and Drag&Drop.

## Version 2.0.1 from 2012 November 25
 - Added the long path support. The DS application can now correctly get access to files and folders with the path longer than 260 characters.
 - Added the support of Save/Load results command.
 - Improved Windows 8 support.
 - Added support for alternate NTFS-streams by comparing file contents.
 - Improved the performance of processing and comparing of the small files.
 - Added some new check/uncheck commands.
 - Added some tooltips with detailed command descriptions.
 - Added support for checking NTFS-permissions compatibility for the files being replaced by hard links.
 - Added experimental option to ignore differences in MP3-files metadata (ID3-tags) and compare the music content only. This option allows finding MP3-files with identical music content, but different ID3-tags.
 - Fixed some small bugs.
 - May be added some new ones. :)

====

## Version 1.6.5.1 from 2010 September 30
 - Fixed small resizing problem in "Select folders to scan" dialog.

## Version 1.6.5 from 2010 September 19
 - Fixed bug: checkbox "Hide files if path contains symbolic link" did not work correctly in 
## Version 1.6.4.1
 - Text "Reparsed path" was replaced with "Real path" to be more understandable for users.

## Version 1.6.4 from 2010 August 24
 - Fixed some small bugs.

## Version 1.6.3 from 2010 June 09
 - Added: Italian language.

## Version 1.6.3 from 2010 February 06
 - Fixed small bug: the option "Automatically Check For Updates" was always on after the restart of the application.
 - Added: the application requests administrator rights on Windows Vista and Windows 7.

## Version 1.6.2 from 2009 December 01
 - Fixed bug: the application hangs when user presses "Check All" in "Find in List" dialog.
 - Added: Windows 7 taskbar extensions support.
 - Some minor fixes.

## Version 1.6.1 from 2009 November 16
 - Fixed: link controls were not updated by checking files from "Find in List" dialog.
 
## Version 1.6 from 2009 November 15
 - Fixed: some small bugs.
 - Added: new commands: 
	- "Exclude Checked Files From the List",
	- "Check All Files in This Folder",
	- "Uncheck All Files in This Folder",
	- "Find in List".
 - Added: buttons to hide optical, removable and network drives in folder tree.

## Version 1.5.1 from 2009 October 25
 - Fixed: commands "Collapse All" and "Expand All" did not work in version 1.5.
 - Added: Japanese language.
 
## Version 1.5 from 2009 October 10
 - Fixed: the application did not work on Win64 systems.
 - Fixed: significantly improved performance and decreased memory consumption of application by work with the huge list of found files.
 - Added: the application automatically updates result list, when files were deleted or modified by external applications.
 - Fixed: some small bugs.

## Version 1.4.3 from 2009 July 02
 - Added: context menu commands "Check All" and "Uncheck All" to select folder dialog.
 - Added: new command "Uncheck Other NTFS-links If Any Is Unchecked". This command allows to make unchecked the whole group of hard and soft NTFS-links to the file in order to use this file as a target for new hard links.
 - Fixed: a crush when user clicks "Hide groups without real duplicates" checkbox and empty list must be shown.
 - Improved: result list scroll speed.

## Version 1.4.2 from 2009 May 04
 - Fixed: some small interface-related bugs.

## Version 1.4.1 from 2009 April 17
 - Added: shortcuts for commands.
 - Added: new search option "Search only NTFS-links to the same files".

## Version 1.4 from 2009 March 8
 - Added: progress window to indicate process of deleting, replacing with hard links and detaching hard links.
 - Added: application can now automatically check for updates.
 - Some internal code improvements.

## Version 1.3.1 from 2009 January 10
 - Added possibility to rename files via editing filename directly in grid.
 - Now application automatically saves/restores the position of the main window on close/open. 

## Version 1.3.0 from 2008 December 22
 - Renamed to "Duplicate and Same Files Searcher".
 - Added possibility to compress files on NTFS volumes.
 - Compressed files on NTFS volumes are displayed in blue color.
 - "Size on disk" is now displayed in "Size" column.
 - Fixed incorrect sorting by file name in result list.

## Version 1.2.1 from 2008 November 13
 - Added: sorting mode in descending and ascending order was implemented for "Size" column. 
 - Descending order is default for scanning and result sorting now.

## Version 1.2.0 from 2008 October 21
 - Added: now user can enter "Include" and "Exclude" masks for scanning files.
 - Added: progress bar to indicate scan process.
 - Added: new operation "Detach Hard Links".
 - Added: if replaced files are in use by another process, they will be deleted automatically on the next reboot.
 - Fixed problem: operations for checked files did not proceed if group was collapsed.
 - Fixed some interface issues.
 - Fixed some minor internal bugs.
 - Speed was improved.
 - Memory consumption was decreased.
 
## Version 1.1.0 from 2008 September 04
 - Added: new search option "Skip files, which don't occupy disk space (resident files)".
 - Added: new search option "Skip symbolic links (directory junctions)".
 - Added: search options are now saved and restored automatically on program exit/start.
 - Added: possibility to copy file paths to clipboard.
 - Performance of filling grid operation was increased.

## Version 1.0.8 from 2008 August 14
 - Fixed some spelling mistakes.
 - Fixed some interface issues.

## Version 1.0.7 from 2008 July 18
 - Added: hint string in the status bar.

## Version 1.0.6 from 2008 July 16 
 - Some changes in the interface.
 - Fixed some small interface problems.
 - Added: now the number of file fragments on the disk is shown.

## Version 1.0.1 from 2008 March 10
 - First release.
