/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.shared.util;

import androidx.compose.runtime.internal.StabilityInferred;
import ir.amirab.downloader.utils.NumUtilKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fJ*\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a8\u0006\u0012"}, d2={"Lcom/abdownloadmanager/shared/util/HashUtil;", "", "<init>", "()V", "hash", "", "algorithm", "inputStream", "Ljava/io/InputStream;", "size", "", "onNewPercent", "Lkotlin/Function1;", "", "", "fileHash", "file", "Ljava/io/File;", "app"})
@StabilityInferred(parameters=1)
public final class HashUtil {
    @NotNull
    public static final HashUtil INSTANCE = new HashUtil();
    public static final int $stable;

    private HashUtil() {
    }

    @NotNull
    public final String hash(@NotNull String algorithm, @NotNull InputStream inputStream, long size, @NotNull Function1<? super Integer, Unit> onNewPercent) {
        int readCount;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter(onNewPercent, (String)"onNewPercent");
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        byte[] buffer = new byte[8192];
        long processedBytes = 0L;
        int lastPercent = 0;
        while ((readCount = inputStream.read(buffer)) != -1) {
            messageDigest.update(buffer, 0, readCount);
            int newPercent = NumUtilKt.calcPercent((long)(processedBytes += (long)readCount), (long)size);
            if (newPercent == lastPercent) continue;
            onNewPercent.invoke((Object)newPercent);
            lastPercent = newPercent;
        }
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, HashUtil::hash$lambda$0, (int)30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String fileHash(@NotNull String algorithm, @NotNull File file, @NotNull Function1<? super Integer, Unit> onNewPercent) {
        String string;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(onNewPercent, (String)"onNewPercent");
        long fileSize = file.length();
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            string = INSTANCE.hash(algorithm, it, fileSize, onNewPercent);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    private static final CharSequence hash$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

