/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.collection.MutableScatterMap;
import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.collection.ScatterSetKt;
import androidx.compose.ui.layout.Ruler;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LookaheadCapablePlaceable;
import androidx.compose.ui.node.WeakReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0014J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0014H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\bH\u0086\u0002J8\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2 \u0010 \u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f\u0018\u00010!J\u0006\u0010\"\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/compose/ui/node/RulerTrackingMap;", "", "<init>", "()V", "size", "", "rulers", "", "Landroidx/compose/ui/layout/Ruler;", "[Landroidx/compose/ui/layout/Ruler;", "values", "", "accessFlags", "", "layoutNodes", "Landroidx/collection/MutableScatterSet;", "Landroidx/compose/ui/node/WeakReference;", "Landroidx/compose/ui/node/LayoutNode;", "newRulers", "getOrDefault", "", "ruler", "defaultValue", "set", "", "value", "contains", "", "notifyChanged", "isLookingAhead", "node", "Landroidx/compose/ui/node/LookaheadCapablePlaceable;", "rulerReaders", "Landroidx/collection/MutableScatterMap;", "clear", "ui"})
@SourceDebugExtension(value={"SMAP\nLookaheadDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookaheadDelegate.kt\nandroidx/compose/ui/node/RulerTrackingMap\n+ 2 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,686:1\n231#2,3:687\n200#2,7:690\n211#2,3:698\n214#2,9:702\n234#2:711\n231#2,3:712\n200#2,7:715\n211#2,3:723\n214#2,9:727\n234#2:736\n1399#3:697\n1270#3:701\n1399#3:722\n1270#3:726\n*S KotlinDebug\n*F\n+ 1 LookaheadDelegate.kt\nandroidx/compose/ui/node/RulerTrackingMap\n*L\n639#1:687,3\n639#1:690,7\n639#1:698,3\n639#1:702,9\n639#1:711\n646#1:712,3\n646#1:715,7\n646#1:723,3\n646#1:727,9\n646#1:736\n639#1:697\n639#1:701\n646#1:722\n646#1:726\n*E\n"})
final class RulerTrackingMap {
    private int size;
    @NotNull
    private Ruler[] rulers = new Ruler[32];
    @NotNull
    private float[] values = new float[32];
    @NotNull
    private byte[] accessFlags = new byte[32];
    @NotNull
    private MutableScatterSet<WeakReference<LayoutNode>> layoutNodes = ScatterSetKt.mutableScatterSetOf();
    @NotNull
    private final MutableScatterSet<Ruler> newRulers = ScatterSetKt.mutableScatterSetOf();

    public final float getOrDefault(@NotNull Ruler ruler, float defaultValue) {
        Intrinsics.checkNotNullParameter((Object)ruler, (String)"ruler");
        int index = ArraysKt.indexOf((Object[])this.rulers, (Object)ruler);
        return index < 0 ? defaultValue : this.values[index];
    }

    public final void set(@NotNull Ruler ruler, float value) {
        Intrinsics.checkNotNullParameter((Object)ruler, (String)"ruler");
        int index = ArraysKt.indexOf((Object[])this.rulers, (Object)ruler);
        if (index < 0) {
            int newIndex = this.size;
            if (newIndex == this.rulers.length) {
                int newSize = newIndex * 2;
                Ruler[] rulerArray = Arrays.copyOf(this.rulers, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)rulerArray, (String)"copyOf(...)");
                this.rulers = rulerArray;
                float[] fArray = Arrays.copyOf(this.values, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
                this.values = fArray;
                byte[] byArray = Arrays.copyOf(this.accessFlags, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
                this.accessFlags = byArray;
            }
            this.rulers[newIndex] = ruler;
            this.accessFlags[newIndex] = 3;
            this.values[newIndex] = value;
            int n = this.size;
            this.size = n + 1;
        } else {
            float oldValue = this.values[index];
            if (!(oldValue == value)) {
                this.values[index] = value;
                this.accessFlags[index] = 1;
            } else if (this.accessFlags[index] == 2) {
                this.accessFlags[index] = 0;
            }
        }
    }

    public final boolean contains(@NotNull Ruler ruler) {
        Intrinsics.checkNotNullParameter((Object)ruler, (String)"ruler");
        return ArraysKt.contains((Object[])this.rulers, (Object)ruler);
    }

    public final void notifyChanged(boolean isLookingAhead, @NotNull LookaheadCapablePlaceable node, @Nullable MutableScatterMap<Ruler, MutableScatterSet<WeakReference<LayoutNode>>> rulerReaders) {
        boolean bl;
        int index$iv;
        int index$iv$iv;
        boolean $i$f$isFull;
        long value$iv$iv$iv;
        int j$iv$iv;
        int bitCount$iv$iv;
        boolean $i$f$maskEmptyOrDeleted;
        long $this$maskEmptyOrDeleted$iv$iv$iv;
        long slot$iv$iv;
        int access;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            access = this.accessFlags[i];
            if (access == 3) {
                Ruler ruler = this.rulers[i];
                Intrinsics.checkNotNull((Object)ruler);
                this.newRulers.plusAssign((Object)ruler);
                continue;
            }
            if (access == 0 || rulerReaders == null) continue;
            Ruler ruler = this.rulers[i];
            Intrinsics.checkNotNull((Object)ruler);
            MutableScatterSet readers = (MutableScatterSet)rulerReaders.remove((Object)ruler);
            if (readers == null) continue;
            this.layoutNodes.plusAssign((ScatterSet)readers);
        }
        int removed = 0;
        access = this.size;
        for (int sourceIndex = 0; sourceIndex < access; ++sourceIndex) {
            if (this.accessFlags[sourceIndex] == 2) {
                ++removed;
            } else if (removed > 0) {
                int destIndex = sourceIndex - removed;
                this.rulers[destIndex] = this.rulers[sourceIndex];
            }
            this.accessFlags[sourceIndex] = 2;
        }
        access = this.size;
        for (int i = this.size - removed; i < access; ++i) {
            this.rulers[i] = null;
        }
        this.size -= removed;
        LookaheadCapablePlaceable parent = node.getParent();
        ScatterSet this_$iv = (ScatterSet)this.newRulers;
        boolean $i$f$forEach = false;
        Object[] elements$iv = this_$iv.elements;
        ScatterSet this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            bl = false;
                            Ruler ruler = (Ruler)elements$iv[index$iv];
                            boolean bl2 = false;
                            LookaheadCapablePlaceable lookaheadCapablePlaceable = parent;
                            if (lookaheadCapablePlaceable == null) {
                                lookaheadCapablePlaceable = node;
                            }
                            lookaheadCapablePlaceable.invalidateChildrenOfDefiningRuler$ui(ruler);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this.newRulers.clear();
        this_$iv = (ScatterSet)this.layoutNodes;
        $i$f$forEach = false;
        elements$iv = this_$iv.elements;
        this_$iv$iv = this_$iv;
        $i$f$forEachIndex = false;
        m$iv$iv = this_$iv$iv.metadata;
        lastIndex$iv$iv = m$iv$iv.length - 2;
        i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            bl = false;
                            WeakReference layoutNodeRef = (WeakReference)elements$iv[index$iv];
                            boolean bl3 = false;
                            if ((LayoutNode)layoutNodeRef.get() != null) {
                                LayoutNode layoutNode;
                                boolean bl4 = false;
                                if (isLookingAhead) {
                                    layoutNode.requestLookaheadRelayout$ui(false);
                                } else {
                                    layoutNode.requestRelayout$ui(false);
                                }
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this.layoutNodes.clear();
    }

    public final void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.rulers[i] = null;
            this.values[i] = Float.NaN;
            this.accessFlags[i] = 0;
        }
        this.size = 0;
    }
}

