/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.startup;

import ir.amirab.util.platform.Platform;
import ir.amirab.util.startup.AbstractDesktopStartupManager;
import ir.amirab.util.startup.HeadlessStartupDesktop;
import ir.amirab.util.startup.MacOSStartupDesktop;
import ir.amirab.util.startup.UnixXDGStartupDesktop;
import ir.amirab.util.startup.Utils;
import ir.amirab.util.startup.WindowsStartupDesktop;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\u0007J\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lir/amirab/util/startup/Startup;", "", "<init>", "()V", "getStartUpManagerForDesktop", "Lir/amirab/util/startup/AbstractDesktopStartupManager;", "name", "", "path", "args", "", "packageName", "noImplStartUpManager", "Lir/amirab/util/startup/HeadlessStartupDesktop;", "auto-start"})
public final class Startup {
    @NotNull
    public static final Startup INSTANCE = new Startup();

    private Startup() {
    }

    @NotNull
    public final AbstractDesktopStartupManager getStartUpManagerForDesktop(@NotNull String name, @Nullable String path, @NotNull List<String> args, @NotNull String packageName) throws Exception {
        AbstractDesktopStartupManager abstractDesktopStartupManager;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (path == null) {
            return this.noImplStartUpManager();
        }
        Platform os = Platform.Companion.getCurrentPlatform();
        Platform platform = os;
        if (Intrinsics.areEqual((Object)platform, (Object)Platform.Desktop.Linux.INSTANCE)) {
            abstractDesktopStartupManager = Utils.INSTANCE.isHeadless() ? (AbstractDesktopStartupManager)new HeadlessStartupDesktop(name, path, args) : (AbstractDesktopStartupManager)new UnixXDGStartupDesktop(name, path, args, packageName);
        } else if (Intrinsics.areEqual((Object)platform, (Object)Platform.Desktop.MacOS.INSTANCE)) {
            abstractDesktopStartupManager = new MacOSStartupDesktop(name, path, args);
        } else if (Intrinsics.areEqual((Object)platform, (Object)Platform.Desktop.Windows.INSTANCE)) {
            abstractDesktopStartupManager = new WindowsStartupDesktop(name, path, args);
        } else {
            if (Intrinsics.areEqual((Object)platform, (Object)Platform.Android.INSTANCE)) {
                throw new IllegalStateException("this code should not be called in android".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        AbstractDesktopStartupManager startup = abstractDesktopStartupManager;
        return startup;
    }

    private final HeadlessStartupDesktop noImplStartUpManager() {
        return new HeadlessStartupDesktop("", "", CollectionsKt.emptyList());
    }
}

