/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.desktop;

import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidableCompositionLocal;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.window.FrameWindowScope;
import ir.amirab.util.desktop.DesktopPlatform;
import java.awt.ComponentOrientation;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u000e*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u0011\u001a\u00020\u000e*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016\"\u0013\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"LocalFrameWindowScope", "Landroidx/compose/runtime/ProvidableCompositionLocal;", "Landroidx/compose/ui/window/FrameWindowScope;", "getLocalFrameWindowScope", "()Landroidx/compose/runtime/ProvidableCompositionLocal;", "GlobalDensity", "Landroidx/compose/ui/unit/Density;", "getGlobalDensity", "()Landroidx/compose/ui/unit/Density;", "density", "Ljava/awt/GraphicsConfiguration;", "getDensity", "(Ljava/awt/GraphicsConfiguration;)Landroidx/compose/ui/unit/Density;", "GlobalLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getGlobalLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "layoutDirection", "Ljava/util/Locale;", "getLayoutDirection", "(Ljava/util/Locale;)Landroidx/compose/ui/unit/LayoutDirection;", "Ljava/awt/ComponentOrientation;", "(Ljava/awt/ComponentOrientation;)Landroidx/compose/ui/unit/LayoutDirection;", "trayIconSize", "Landroidx/compose/ui/geometry/Size;", "getTrayIconSize", "()J", "J", "shared"})
@SourceDebugExtension(value={"SMAP\nOsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OsUtils.kt\nir/amirab/util/desktop/OsUtilsKt\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,71:1\n33#2:72\n33#2:76\n33#2:80\n33#2:84\n53#3,3:73\n53#3,3:77\n53#3,3:81\n53#3,3:85\n*S KotlinDebug\n*F\n+ 1 OsUtils.kt\nir/amirab/util/desktop/OsUtilsKt\n*L\n42#1:72\n44#1:76\n46#1:80\n47#1:84\n42#1:73,3\n44#1:77,3\n46#1:81,3\n47#1:85,3\n*E\n"})
public final class OsUtilsKt {
    @NotNull
    private static final ProvidableCompositionLocal<FrameWindowScope> LocalFrameWindowScope = CompositionLocalKt.compositionLocalOf$default(null, OsUtilsKt::LocalFrameWindowScope$lambda$0, (int)1, null);
    private static final long trayIconSize = switch (WhenMappings.$EnumSwitchMapping$0[DesktopPlatform.Companion.getCurrent().ordinal()]) {
        case 1 -> {
            void width$iv;
            float var0 = 22.0f;
            float height$iv = 22.0f;
            boolean $i$f$Size = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
            long v2$iv$iv = Float.floatToRawIntBits(height$iv);
            yield Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        }
        case 2 -> {
            float width$iv = 16.0f;
            float height$iv = 16.0f;
            boolean $i$f$Size = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(width$iv);
            long v2$iv$iv = Float.floatToRawIntBits(height$iv);
            yield Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        }
        case 3 -> {
            float width$iv = 22.0f;
            float height$iv = 22.0f;
            boolean $i$f$Size = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(width$iv);
            long v2$iv$iv = Float.floatToRawIntBits(height$iv);
            yield Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        }
        case 4 -> {
            float width$iv = 32.0f;
            float height$iv = 32.0f;
            boolean $i$f$Size = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(width$iv);
            long v2$iv$iv = Float.floatToRawIntBits(height$iv);
            yield Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        }
        default -> throw new NoWhenBranchMatchedException();
    };

    @NotNull
    public static final ProvidableCompositionLocal<FrameWindowScope> getLocalFrameWindowScope() {
        return LocalFrameWindowScope;
    }

    @NotNull
    public static final Density getGlobalDensity() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getDefaultConfiguration(...)");
        return OsUtilsKt.getDensity(graphicsConfiguration);
    }

    @NotNull
    public static final Density getDensity(@NotNull GraphicsConfiguration $this$density) {
        Intrinsics.checkNotNullParameter((Object)$this$density, (String)"<this>");
        return DensityKt.Density((float)((float)$this$density.getDefaultTransform().getScaleX()), (float)1.0f);
    }

    @NotNull
    public static final LayoutDirection getGlobalLayoutDirection() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        return OsUtilsKt.getLayoutDirection(locale);
    }

    @NotNull
    public static final LayoutDirection getLayoutDirection(@NotNull Locale $this$layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$layoutDirection, (String)"<this>");
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation($this$layoutDirection);
        Intrinsics.checkNotNullExpressionValue((Object)componentOrientation, (String)"getOrientation(...)");
        return OsUtilsKt.getLayoutDirection(componentOrientation);
    }

    @NotNull
    public static final LayoutDirection getLayoutDirection(@NotNull ComponentOrientation $this$layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$layoutDirection, (String)"<this>");
        return $this$layoutDirection.isLeftToRight() ? LayoutDirection.Ltr : ($this$layoutDirection.isHorizontal() ? LayoutDirection.Rtl : LayoutDirection.Ltr);
    }

    public static final long getTrayIconSize() {
        return trayIconSize;
    }

    private static final FrameWindowScope LocalFrameWindowScope$lambda$0() {
        throw new IllegalStateException("LocalFrameWindowScope not provided yet".toString());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DesktopPlatform.values().length];
            try {
                nArray[DesktopPlatform.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DesktopPlatform.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DesktopPlatform.MacOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DesktopPlatform.Unknown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

