/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.utils.native_messaging;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.desktop.utils.AppInfo;
import com.abdownloadmanager.desktop.utils.AppInfoKt;
import com.abdownloadmanager.desktop.utils.native_messaging.ChromeNativeMessagingManifest;
import com.abdownloadmanager.desktop.utils.native_messaging.FirefoxNativeMessagingManifest;
import com.abdownloadmanager.desktop.utils.native_messaging.NativeMessagingManifestApplier;
import com.abdownloadmanager.desktop.utils.native_messaging.NativeMessagingManifests;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/abdownloadmanager/desktop/utils/native_messaging/NativeMessaging;", "", "nativeMessagingManifestApplier", "Lcom/abdownloadmanager/desktop/utils/native_messaging/NativeMessagingManifestApplier;", "<init>", "(Lcom/abdownloadmanager/desktop/utils/native_messaging/NativeMessagingManifestApplier;)V", "boot", "", "installManifests", "createFirefoxManifest", "Lcom/abdownloadmanager/desktop/utils/native_messaging/FirefoxNativeMessagingManifest;", "createChromeManifest", "Lcom/abdownloadmanager/desktop/utils/native_messaging/ChromeNativeMessagingManifest;", "app"})
@StabilityInferred(parameters=0)
public final class NativeMessaging {
    @NotNull
    private final NativeMessagingManifestApplier nativeMessagingManifestApplier;
    public static final int $stable = 8;

    public NativeMessaging(@NotNull NativeMessagingManifestApplier nativeMessagingManifestApplier) {
        Intrinsics.checkNotNullParameter((Object)nativeMessagingManifestApplier, (String)"nativeMessagingManifestApplier");
        this.nativeMessagingManifestApplier = nativeMessagingManifestApplier;
    }

    public final void boot() {
        this.installManifests();
    }

    public final void installManifests() {
        FirefoxNativeMessagingManifest firefox = this.createFirefoxManifest();
        ChromeNativeMessagingManifest chrome = this.createChromeManifest();
        if (chrome != null && firefox != null) {
            this.nativeMessagingManifestApplier.updateManifests(new NativeMessagingManifests(firefox, chrome));
        }
    }

    private final FirefoxNativeMessagingManifest createFirefoxManifest() {
        if (!AppInfoKt.isAppInstalled(AppInfo.INSTANCE)) {
            return null;
        }
        String string = AppInfo.INSTANCE.getExeFile();
        Intrinsics.checkNotNull((Object)string);
        String execFile = string;
        return new FirefoxNativeMessagingManifest(AppInfo.INSTANCE.getDisplayName(), AppInfo.INSTANCE.getDisplayName(), execFile, "stdio", CollectionsKt.listOf((Object)""));
    }

    private final ChromeNativeMessagingManifest createChromeManifest() {
        if (!AppInfoKt.isAppInstalled(AppInfo.INSTANCE)) {
            return null;
        }
        String string = AppInfo.INSTANCE.getExeFile();
        Intrinsics.checkNotNull((Object)string);
        String execFile = string;
        return new ChromeNativeMessagingManifest(AppInfo.INSTANCE.getDisplayName(), AppInfo.INSTANCE.getDisplayName(), execFile, "stdio", CollectionsKt.listOf((Object)""));
    }
}

