/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core.cookie;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.KotlinExtensionsKt;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.cookie.Cookie;
import org.http4k.core.cookie.CookieExtensionsKt;
import org.http4k.core.cookie.SameSite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\u0012\u0010\u0000\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r*\u00020\bH\u0000\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\r*\u00020\u0006\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u000f\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\r*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0002*\u00020\u0002\u001a*\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0014"}, d2={"cookie", "Lorg/http4k/core/Response;", "Lorg/http4k/core/cookie/Cookie;", "unquotedValue", "", "removeCookie", "Lorg/http4k/core/Request;", "name", "", "replaceCookie", "value", "new", "toCookieList", "", "cookies", "toCookieString", "invalidate", "invalidateCookie", "domain", "path", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nCookieExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CookieExtensions.kt\norg/http4k/core/cookie/CookieExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n832#2:45\n862#2,2:46\n1849#2,3:48\n777#2:51\n873#2,2:52\n1849#2,3:54\n1586#2:57\n1661#2,3:58\n777#2:61\n873#2,2:62\n1661#2,2:64\n1663#2:67\n777#2:68\n873#2,2:69\n1642#2,10:71\n1915#2:81\n1916#2:83\n1652#2:84\n1849#2,3:85\n777#2:88\n873#2,2:89\n2045#2,14:91\n1642#2,10:105\n1915#2:115\n1916#2:117\n1652#2:118\n1#3:66\n1#3:82\n1#3:116\n*S KotlinDebug\n*F\n+ 1 CookieExtensions.kt\norg/http4k/core/cookie/CookieExtensionsKt\n*L\n11#1:45\n11#1:46,2\n11#1:48,3\n16#1:51\n16#1:52,2\n16#1:54,3\n25#1:57\n25#1:58,3\n25#1:61\n25#1:62,2\n25#1:64,2\n25#1:67\n28#1:68\n28#1:69,2\n29#1:71,10\n29#1:81\n29#1:83\n29#1:84\n30#1:85,3\n32#1:88\n32#1:89,2\n32#1:91,14\n38#1:105,10\n38#1:115\n38#1:117\n38#1:118\n29#1:82\n38#1:116\n*E\n"})
public final class CookieExtensionsKt {
    @NotNull
    public static final Response cookie(@NotNull Response $this$cookie, @NotNull Cookie cookie, boolean unquotedValue) {
        Intrinsics.checkNotNullParameter((Object)$this$cookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return $this$cookie.header("Set-Cookie", cookie.fullCookieString(unquotedValue));
    }

    public static /* synthetic */ Response cookie$default(Response response, Cookie cookie, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return CookieExtensionsKt.cookie(response, cookie, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Request removeCookie(@NotNull Request $this$removeCookie, @NotNull String name) {
        void $this$fold$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$removeCookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filterNot$iv = CookieExtensionsKt.cookies($this$removeCookie);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Cookie it = (Cookie)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        Request initial$iv = $this$removeCookie.removeHeader("Cookie");
        boolean $i$f$fold = false;
        Request accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void c;
            Object element$iv$iv;
            element$iv$iv = (Cookie)element$iv;
            Request acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CookieExtensionsKt.cookie(acc, (Cookie)c);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Response removeCookie(@NotNull Response $this$removeCookie, @NotNull String name) {
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$removeCookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<String> oldCookies = $this$removeCookie.headerValues("Set-Cookie");
        Response next = $this$removeCookie.removeHeader("Set-Cookie");
        Iterable $this$filter$iv = oldCookies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(it != null && !StringsKt.startsWith$default((String)it, (String)(name + "="), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Response initial$iv = next;
        boolean $i$f$fold = false;
        Response accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void c;
            Object element$iv$iv;
            element$iv$iv = (String)element$iv;
            Response acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.header("Set-Cookie", (String)c);
        }
        return accumulator$iv;
    }

    @NotNull
    public static final Response replaceCookie(@NotNull Response $this$replaceCookie, @NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceCookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return CookieExtensionsKt.cookie$default(CookieExtensionsKt.removeCookie($this$replaceCookie, cookie.getName()), cookie, false, 2, null);
    }

    @NotNull
    public static final Request cookie(@NotNull Request $this$cookie, @NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)$this$cookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return $this$cookie.replaceHeader("Cookie", CookieExtensionsKt.toCookieString(CollectionsKt.plus((Collection)CookieExtensionsKt.cookies($this$cookie), (Object)new Cookie(name, value2, null, null, null, null, false, false, null, 508, null))));
    }

    @NotNull
    public static final Request cookie(@NotNull Request $this$cookie, @NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)$this$cookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"new");
        return $this$cookie.replaceHeader("Cookie", CookieExtensionsKt.toCookieString(CollectionsKt.plus((Collection)CookieExtensionsKt.cookies($this$cookie), (Object)cookie)));
    }

    @NotNull
    public static final List<Cookie> toCookieList(@NotNull String $this$toCookieList) {
        Iterable $this$filterTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toCookieList, (String)"<this>");
        String[] stringArray = new String[]{";"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$toCookieList, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List it2 = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)2, (int)2, null);
            boolean bl3 = false;
            String string = (String)it2.get(0);
            int n = 1;
            List list = it2;
            if (n < list.size()) {
                object = list.get(n);
            } else {
                int n2 = n;
                String string2 = string;
                boolean bl4 = false;
                object = "\"\"";
                string = string2;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 508;
            SameSite sameSite = null;
            boolean bl5 = false;
            boolean bl6 = false;
            String string3 = null;
            String string4 = null;
            Instant instant2 = null;
            Long l = null;
            String string5 = KotlinExtensionsKt.unquoted((String)object);
            String string6 = string;
            collection.add(new Cookie(string6, string5, l, instant2, string4, string3, bl6, bl5, sameSite, n3, defaultConstructorMarker));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull Request $this$cookies) {
        void $this$fold$iv;
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cookies, (String)"<this>");
        Iterable $this$filter$iv = $this$cookies.getHeaders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals((String)((String)it.getFirst()), (String)"cookie", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            List<Cookie> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl2 = false;
            String string = (String)it2.getSecond();
            if ((string != null ? CookieExtensionsKt.toCookieList(string) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void current;
            List $i$f$forEach2 = (List)element$iv;
            List acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.plus((Collection)acc, (Iterable)((Iterable)current));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Cookie cookie(@NotNull Request $this$cookie, @NotNull String name) {
        Object v0;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = CookieExtensionsKt.cookies($this$cookie);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Cookie it = (Cookie)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Cookie it = (Cookie)maxElem$iv;
                boolean bl = false;
                String string = it.getPath();
                int maxValue$iv = string != null ? string.length() : 0;
                do {
                    int v$iv;
                    Object e$iv = iterator$iv.next();
                    Cookie it2 = (Cookie)e$iv;
                    $i$a$-maxByOrNull-CookieExtensionsKt$cookie$2 = false;
                    String string2 = it2.getPath();
                    int n = v$iv = string2 != null ? string2.length() : 0;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private static final String toCookieString(List<Cookie> $this$toCookieString) {
        return CollectionsKt.joinToString$default((Iterable)$this$toCookieString, (CharSequence)"; ", null, null, (int)0, null, (Function1)toCookieString.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull Response $this$cookies) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cookies, (String)"<this>");
        Iterable $this$mapNotNull$iv = CollectionsKt.filterNotNull((Iterable)$this$cookies.headerValues("set-cookie"));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Cookie it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (Cookie.Companion.parse(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Cookie invalidate(@NotNull Cookie $this$invalidate) {
        Intrinsics.checkNotNullParameter((Object)$this$invalidate, (String)"<this>");
        Cookie cookie = Cookie.copy$default($this$invalidate, null, "", null, null, null, null, false, false, null, 509, null).maxAge(0L);
        Instant instant2 = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"EPOCH");
        return cookie.expires(instant2);
    }

    @NotNull
    public static final Response invalidateCookie(@NotNull Response $this$invalidateCookie, @NotNull String name, @Nullable String domain, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)$this$invalidateCookie, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return CookieExtensionsKt.replaceCookie($this$invalidateCookie, CookieExtensionsKt.invalidate(new Cookie(name, "", null, null, domain, path, false, false, null, 460, null)));
    }

    public static /* synthetic */ Response invalidateCookie$default(Response response, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return CookieExtensionsKt.invalidateCookie(response, string, string2, string3);
    }
}

