/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.connections.base.AbstractConnectionBase;
import org.freedesktop.dbus.connections.base.ConnectionMethodInvocation;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.errors.InvalidMethodArgument;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.propertyref.PropRefRemoteHandler;
import org.freedesktop.dbus.propertyref.PropertyRef;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DBusBoundPropertyHandler
extends ConnectionMethodInvocation {
    private static final Method PROP_GETALL_METHOD = PropRefRemoteHandler.getPropertiesMethod("GetAll", String.class);

    protected DBusBoundPropertyHandler(ConnectionConfig _conCfg, TransportConfig _transportConfig, ReceivingServiceConfig _rsCfg) throws DBusException {
        super(_conCfg, _transportConfig, _rsCfg);
    }

    protected PropHandled handleDBusBoundProperties(ExportedObject _exportObject, MethodCall _methodCall, Object[] _params) throws DBusException {
        if (_params.length == 2 && _params[0] instanceof String && _params[1] instanceof String && _methodCall.getName().equals("Get")) {
            return this.handleGet(_exportObject, _methodCall, _params);
        }
        if (_params.length == 3 && _params[0] instanceof String && _params[1] instanceof String && _methodCall.getName().equals("Set")) {
            return this.handleSet(_exportObject, _methodCall, _params);
        }
        if (_params.length == 1 && _params[0] instanceof String && _methodCall.getName().equals("GetAll")) {
            return this.handleGetAll(_exportObject, _methodCall);
        }
        return PropHandled.NOT_HANDLED;
    }

    protected PropHandled handleGetAll(ExportedObject _exportObject, MethodCall _methodCall) throws DBusException {
        Set<Map.Entry<PropertyRef, Method>> allPropertyMethods = _exportObject.getPropertyMethods().entrySet();
        if (!allPropertyMethods.isEmpty()) {
            DBusInterface object = _exportObject.getObject().get();
            Method meth = null;
            if (object instanceof Properties) {
                meth = _exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()));
                if (null == meth) {
                    this.sendMessage(this.getMessageFactory().createError(_methodCall, new UnknownMethod(String.format("The method `%s.%s' does not exist on this object.", _methodCall.getInterface(), _methodCall.getName()))));
                    return PropHandled.HANDLED;
                }
            } else {
                meth = PROP_GETALL_METHOD;
            }
            Method originalMeth = meth;
            this.getReceivingService().execMethodCallHandler(() -> {
                HashMap<String, Variant<Object>> resultMap = new HashMap<String, Variant<Object>>();
                for (Map.Entry propEn : allPropertyMethods) {
                    Method propMeth = (Method)propEn.getValue();
                    if (((PropertyRef)propEn.getKey()).getAccess() != DBusProperty.Access.READ) continue;
                    try {
                        _methodCall.setArgs(new Object[0]);
                        Variant<Object> val = this.invokeMethod(_methodCall, propMeth, object);
                        if (val != null && val.getClass().isArray() || Collection.class.isInstance(val) || Map.class.isInstance(val)) {
                            String[] dataType = Marshalling.getDBusType(((Method)propEn.getValue()).getGenericReturnType());
                            String dataTypeStr = Arrays.stream(dataType).collect(Collectors.joining());
                            this.getLogger().trace("Creating embedded Array/Collection/Map of type {}", (Object)dataTypeStr);
                            val = new Variant<Object>(val, dataTypeStr);
                        }
                        resultMap.put(((PropertyRef)propEn.getKey()).getName(), val);
                    }
                    catch (Throwable _ex) {
                        this.getLogger().debug("Error executing method {} on method call {}", new Object[]{propMeth, _methodCall, _ex});
                        this.handleException(_methodCall, new UnknownMethod("Failure in de-serializing message: " + String.valueOf(_ex)));
                    }
                }
                if (object instanceof Properties) {
                    _methodCall.setArgs(new Object[]{_methodCall.getInterface()});
                    resultMap.putAll((Map)this.setupAndInvoke(_methodCall, originalMeth, object, true));
                }
                try {
                    this.invokedMethodReply(_methodCall, originalMeth, resultMap);
                }
                catch (DBusExecutionException _ex) {
                    this.getLogger().debug("Error invoking method call", (Throwable)_ex);
                    this.handleException(_methodCall, _ex);
                }
                catch (Throwable _ex) {
                    this.getLogger().debug("Failed to invoke method call", _ex);
                    this.handleException(_methodCall, new DBusExecutionException(String.format("Error Executing Method %s.%s: %s", _methodCall.getInterface(), _methodCall.getName(), _ex.getMessage()), _ex));
                }
            });
            return PropHandled.HANDLED;
        }
        return PropHandled.NOT_HANDLED;
    }

    protected PropHandled handleGet(ExportedObject _exportObject, MethodCall _methodCall, Object[] _params) {
        PropertyRef propertyRef = new PropertyRef((String)_params[1], null, DBusProperty.Access.READ);
        Method propMeth = _exportObject.getPropertyMethods().get(propertyRef);
        if (propMeth != null) {
            DBusInterface object = _exportObject.getObject().get();
            this.getReceivingService().execMethodCallHandler(() -> {
                _methodCall.setArgs(new Object[0]);
                this.invokeMethodAndReply(_methodCall, propMeth, object, 1 == (_methodCall.getFlags() & 1));
            });
            return PropHandled.HANDLED;
        }
        if (_exportObject.getImplementedInterfaces().contains(Properties.class)) {
            return PropHandled.NOT_HANDLED;
        }
        return PropHandled.NO_PROPERTY;
    }

    protected PropHandled handleSet(ExportedObject _exportObject, MethodCall _methodCall, Object[] _params) {
        PropertyRef propertyRef = new PropertyRef((String)_params[1], null, DBusProperty.Access.WRITE);
        Method propMeth = _exportObject.getPropertyMethods().get(propertyRef);
        if (propMeth != null) {
            DBusInterface object = _exportObject.getObject().get();
            Class<?> type = PropertyRef.typeForMethod(propMeth);
            AtomicBoolean isVariant = new AtomicBoolean(false);
            Object val = Optional.ofNullable(_params[2]).map(v -> {
                if (v instanceof Variant) {
                    Variant va = (Variant)v;
                    isVariant.set(true);
                    return va.getValue();
                }
                return v;
            }).orElse(null);
            this.getReceivingService().execMethodCallHandler(() -> {
                try {
                    AbstractCollection myVal = val;
                    Parameter[] parameters = propMeth.getParameters();
                    if (parameters.length != 1) {
                        throw new InvalidMethodArgument("Expected method with one argument, but found " + parameters.length);
                    }
                    if (Collection.class.isAssignableFrom(parameters[0].getType()) && isVariant.get() && myVal != null && myVal.getClass().isArray()) {
                        myVal = Set.class.isAssignableFrom(parameters[0].getType()) ? new LinkedHashSet<Object>(Arrays.asList(Util.toObjectArray(myVal))) : new ArrayList<Object>(Arrays.asList(Util.toObjectArray(myVal)));
                    }
                    _methodCall.setArgs(Marshalling.deSerializeParameters(new Object[]{myVal}, new Type[]{type}, (AbstractConnectionBase)this));
                    this.invokeMethodAndReply(_methodCall, propMeth, object, 1 == (_methodCall.getFlags() & 1));
                }
                catch (Exception _ex) {
                    this.getLogger().debug("Failed to invoke method call on Properties", (Throwable)_ex);
                    this.handleException(_methodCall, new UnknownMethod("Failure in de-serializing message: " + String.valueOf(_ex)));
                }
            });
            return PropHandled.HANDLED;
        }
        return PropHandled.NOT_HANDLED;
    }

    static enum PropHandled {
        HANDLED,
        NOT_HANDLED,
        NO_PROPERTY;

    }
}

