/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.lazy.layout.LazyLayoutScrollScope;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerScrollPositionKt;
import androidx.compose.foundation.pager.PagerState;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"LazyLayoutScrollScope", "Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;", "state", "Landroidx/compose/foundation/pager/PagerState;", "scrollScope", "Landroidx/compose/foundation/gestures/ScrollScope;", "foundation"})
public final class PagerScrollScopeKt {
    @NotNull
    public static final LazyLayoutScrollScope LazyLayoutScrollScope(@NotNull PagerState state, @NotNull ScrollScope scrollScope2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scrollScope2, (String)"scrollScope");
        return new LazyLayoutScrollScope(scrollScope2, state){
            private final /* synthetic */ ScrollScope $$delegate_0;
            final /* synthetic */ PagerState $state;
            {
                this.$state = $state;
                this.$$delegate_0 = $scrollScope;
            }

            public int getFirstVisibleItemIndex() {
                return this.$state.getFirstVisiblePage$foundation();
            }

            public int getFirstVisibleItemScrollOffset() {
                return this.$state.getFirstVisiblePageOffset$foundation();
            }

            public int getLastVisibleItemIndex() {
                return ((PageInfo)CollectionsKt.last(this.$state.getLayoutInfo().getVisiblePagesInfo())).getIndex();
            }

            public int getItemCount() {
                return this.$state.getPageCount();
            }

            public void snapToItem(int index, int offset) {
                float offsetFraction = (float)offset / (float)this.$state.getPageSizeWithSpacing$foundation();
                this.$state.snapToItem$foundation(index, offsetFraction, true);
            }

            public int calculateDistanceTo(int targetIndex, int targetOffset) {
                int displacement = MathKt.roundToInt((float)((float)((targetIndex - this.$state.getCurrentPage()) * this.$state.getPageSizeWithSpacing$foundation()) - this.$state.getCurrentPageOffsetFraction() * (float)this.$state.getPageSizeWithSpacing$foundation() + (float)targetOffset));
                long currentScrollWithDisplacementApplied = RangesKt.coerceIn((long)(PagerScrollPositionKt.currentAbsoluteScrollOffset(this.$state) + (long)displacement), (long)this.$state.getMinScrollOffset$foundation(), (long)this.$state.getMaxScrollOffset$foundation());
                return (int)(currentScrollWithDisplacementApplied - PagerScrollPositionKt.currentAbsoluteScrollOffset(this.$state));
            }

            public float scrollBy(float pixels) {
                return this.$$delegate_0.scrollBy(pixels);
            }
        };
    }
}

