/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lir/amirab/util/FilenameDecoder;", "", "<init>", "()V", "decode", "", "encoded", "charset", "Ljava/nio/charset/Charset;", "utils"})
public final class FilenameDecoder {
    @NotNull
    public static final FilenameDecoder INSTANCE = new FilenameDecoder();

    private FilenameDecoder() {
    }

    @NotNull
    public final String decode(@NotNull String encoded, @NotNull Charset charset) {
        String string;
        boolean modified;
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        int strIndex = 0;
        StringBuilder stringBuilder = new StringBuilder();
        byte[] bytes = null;
        while (strIndex < encoded.length()) {
            Comparable<Integer> comparable;
            char ch = encoded.charAt(strIndex);
            if (ch == '%') {
                int byteIndex = 0;
                if (bytes == null) {
                    bytes = new byte[(encoded.length() - strIndex) / 3];
                }
                do {
                    if (strIndex + 2 >= encoded.length()) {
                        throw new IllegalArgumentException("Incomplete percent encoding at position " + strIndex);
                    }
                    bytes[byteIndex++] = (byte)Integer.parseInt(encoded, strIndex + 1, strIndex + 3, 16);
                } while ((strIndex += 3) < encoded.length() && (ch = encoded.charAt(strIndex)) == '%');
                comparable = stringBuilder.append(new String(bytes, 0, byteIndex, charset));
                continue;
            }
            stringBuilder.append(ch);
            comparable = strIndex++;
        }
        boolean bl = modified = bytes != null;
        if (modified) {
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = encoded;
        }
        return string;
    }

    public static /* synthetic */ String decode$default(FilenameDecoder filenameDecoder, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return filenameDecoder.decode(string, charset);
    }
}

