/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.http4k;

import java.io.FilterInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lir/amirab/util/http4k/LimitedInputStream;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "maxRead", "", "<init>", "(Ljava/io/InputStream;J)V", "getMaxRead", "()J", "allowedRemaining", "value", "", "readCount", "getReadCount", "()I", "maxReached", "", "reachedEnd", "read", "b", "", "off", "len", "readAllBytes", "readNBytes", "constrainRequestedLength", "nanohttp4k"})
class LimitedInputStream
extends FilterInputStream {
    private final long maxRead;
    private int readCount;

    public LimitedInputStream(@NotNull InputStream inputStream, long maxRead) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
        this.maxRead = maxRead;
    }

    public final long getMaxRead() {
        return this.maxRead;
    }

    public final long allowedRemaining() {
        return this.maxRead - (long)this.readCount;
    }

    public final int getReadCount() {
        return this.readCount;
    }

    public final boolean maxReached() {
        return this.allowedRemaining() <= 0L;
    }

    private final int reachedEnd() {
        return -1;
    }

    @Override
    public int read() {
        if (this.maxReached()) {
            return this.reachedEnd();
        }
        int n = this.readCount;
        this.readCount = n + 1;
        return super.read();
    }

    @Override
    public int read(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        long allowedRead = this.allowedRemaining();
        if (allowedRead <= 0L) {
            return this.reachedEnd();
        }
        long newLen = Math.min(allowedRead, (long)len);
        int result = super.read(b, off, (int)newLen);
        if (result >= 0) {
            this.readCount += result;
        }
        return result;
    }

    @Override
    @NotNull
    public byte[] readAllBytes() {
        return this.readNBytes(Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public byte[] readNBytes(int len) {
        int newLen = this.constrainRequestedLength(len);
        if (newLen < 0) {
            return new byte[0];
        }
        byte[] byArray = super.readNBytes(newLen);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return byArray;
    }

    public final int constrainRequestedLength(int len) {
        return (int)Math.min(this.allowedRemaining(), (long)len);
    }
}

